﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using InfoWorld.EVS.CTSMAPI;
using System.Text;
using System.Web.WebPages;
using System.Linq.Expressions;
using System.Web.Mvc.Html;
using BMS.Web.App_GlobalResource;
using Microsoft.Web.Mvc;
using System.Web.Routing;
using System.Reflection;
using BMS.Utils;
using BMS.Web.Controllers;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.Text.RegularExpressions;
using BMS.Web.Models;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Views
{
    /// <summary>
    /// Html helpers for rendering UI controls 
    /// </summary>
    public static class InputHelpers
    {
        static AntiXssEncoder xssEncoder = new AntiXssEncoder();

        /// <summary>
        /// strong typed action button
        /// </summary>
        /// <typeparam name="TController">controller to call</typeparam>
        /// <param name="url">url helper class</param>
        /// <param name="actionSelector">lambda expresion for action to call</param>
        /// <param name="name">the name of the button</param>
        /// <param name="buttonText">the caption of the button</param>
        /// <returns>a html representing a buuton</returns>
        public static MvcHtmlString CustomActionButton<TController>(this UrlHelper url, Expression<Func<TController, ActionResult>> actionSelector, string name, string buttonText) where TController : Controller
        {
            return CustomActionButton<TController>(url, actionSelector, name, buttonText, "");
        }

        /// <summary>
        /// strong typed action button
        /// </summary>
        /// <typeparam name="TController">controller to call</typeparam>
        /// <param name="url">url helper class</param>
        /// <param name="actionSelector">lambda expresion for action to call</param>
        /// <param name="name">the name of the button</param>
        /// <param name="buttonText">the caption of the button</param>
        /// <param name="htmlAttributesString">a string with html attributes</param>
        /// <returns>a html representing a buton</returns>
        public static MvcHtmlString CustomActionButton<TController>(this UrlHelper url, Expression<Func<TController, ActionResult>> actionSelector, string name, string buttonText, string htmlAttributesString) where TController : Controller
        {
            string controller, action;
            RouteValueDictionary parameters = GetRouteValues(null, actionSelector, out controller, out action);

            var res = "<input type=\"button\" name=\"" + name + "\" value=\"" + buttonText + "\"  " + htmlAttributesString + " onclick=\"location.href='" + url.Action(action, controller, parameters) + "'\"/>";

            return MvcHtmlString.Create(res);
        }

        /// <summary>
        /// strong typed action button
        /// </summary>
        /// <typeparam name="TController">controller to call</typeparam>
        /// <param name="url">url helper class</param>
        /// <param name="actionSelector">lambda expresion for action to call</param>
        /// <param name="name">the name of the button</param>
        /// <param name="buttonText">the caption of the button</param>
        /// <param name="htmlAttributesString">a string with html attributes</param>
        /// <returns>a html representing a buton</returns>
        public static MvcHtmlString CustomActionButton<TController>(this UrlHelper url, Expression<Func<TController, ActionResult>> actionSelector, string name, string buttonText, object routeValues) where TController : Controller
        {
            string controller, action;
            GetRouteValues(null, actionSelector, out controller, out action);

            var res = "<input type=\"button\" name=\"" + name + "\" value=\"" + buttonText + "\" onclick=\"location.href='" + url.Action(action, controller, routeValues) + "'\"/>";

            return MvcHtmlString.Create(res);
        }

        /// <summary>
        /// a date picker control
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// <returns>a html representing a text box and a calendar</returns>
        public static MvcHtmlString CustomDateFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression)
        {
            string id = "datepicker" + dSufix++;
            string res = EditorExtensions.EditorFor(htmlHelper, expression, null, id).ToString() + GetScript(id);
            return MvcHtmlString.Create(res);
        }

        private static int dSufix = 1;
        private static string GetScript(string name)
        {
            return "<script type='text/javascript'>$(function(){$('#" + name + "').datepicker();});</script>";
        }

        /// <summary>
        /// a html helper for rendering a combo for hour and anothe for minutes
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="hourExpression">the expression representing the model and property of the hour part to bind to</param>
        /// <param name="minuteExpression">the expression representing the model and property of the minute part to bind to</param>
        /// <returns>a html representing a combo for hour and a combo fot minutes</returns>
        public static MvcHtmlString CustomTimePickerFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
                Expression<Func<TModel, TProperty>> hourExpression, Expression<Func<TModel, TProperty>> minuteExpression)
        {
            return CustomTimePickerFor<TModel, TProperty>(htmlHelper, hourExpression, minuteExpression, null);
        }

        /// <summary>
        /// a html helper for rendering a combo for hour and anothe for minutes
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="hourExpression">the expression representing the model and property of the hour part to bind to</param>
        /// <param name="minuteExpression">the expression representing the model and property of the minute part to bind to</param>
        /// <returns>a html representing a combo for hour and a combo fot minutes</returns>
        public static MvcHtmlString CustomTimePickerFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
                Expression<Func<TModel, TProperty>> hourExpression, Expression<Func<TModel, TProperty>> minuteExpression, HtmlAttributes htmlAttributes)
        {
            if (htmlAttributes != null && !htmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            IDictionary<string, object> newAttributes = null;
            if (htmlAttributes != null)
                newAttributes = htmlAttributes.BuildAttributes();

            var memberH = (MemberExpression)hourExpression.Body;
            var memberM = (MemberExpression)minuteExpression.Body;
            var param = Expression.Parameter(typeof(TProperty), "value");
            var setH = Expression.Lambda<Action<TModel, TProperty>>(
                Expression.Assign(memberH, param), hourExpression.Parameters[0], param);
            var setM = Expression.Lambda<Action<TModel, TProperty>>(
                Expression.Assign(memberM, param), minuteExpression.Parameters[0], param);

            // compile it
            var actionH = setH.Compile();
            var actionM = setM.Compile();
            var model = htmlHelper.ViewData.Model;
            TProperty propertyH = hourExpression.Compile()(model);
            TProperty propertyM = minuteExpression.Compile()(model);

            //should be string, but double check
            //set the hour value to the D2 format if not set already
            if (propertyH is string)
            {
                string value = (string)Convert.ChangeType(propertyH, typeof(string));
                if (value.Length == 1)
                {
                    value = "0" + value;
                    actionH(model, (TProperty)Convert.ChangeType(value, typeof(TProperty)));
                }
            }
            //set the minute value to the D2 format if not set already
            if (propertyM is string)
            {
                string value = (string)Convert.ChangeType(propertyM, typeof(string));
                if (value.Length == 1)
                {
                    value = "0" + value;
                    actionM(model, (TProperty)Convert.ChangeType(value, typeof(TProperty)));
                }
            }

            string res = SelectExtensions.DropDownListFor(htmlHelper, hourExpression, new SelectList(TimeLists.HourList), newAttributes).ToString() +
             ":" + SelectExtensions.DropDownListFor(htmlHelper, minuteExpression, new SelectList(TimeLists.MinuteList), newAttributes).ToString();

            return MvcHtmlString.Create(res);
        }

        /// <summary>
        /// Html helper for rendering time picker with labels.
        /// </summary>
        /// <typeparam name="TModel">The type of the model to bind to.</typeparam>
        /// <typeparam name="TProperty">The type of the property of the model to bind to.</typeparam>
        /// <param name="htmlHelper">The HTML helper used to render the control.</param>
        /// <param name="hourExpression">The hour expression.</param>
        /// <param name="minuteExpression">The minute expression.</param>
        /// <param name="labelHourHtmlAttributes">The label hour HTML attributes.</param>
        /// <param name="dropDownHourHtmlAttributes">The drop down hour HTML attributes.</param>
        /// <param name="labelMinuteHtmlAttributes">The label minute HTML attributes.</param>
        /// <param name="dropDownMinuteHtmlAttributes">The drop down minute HTML attributes.</param>
        /// <returns></returns>
        public static MvcHtmlString CustomTimePickerWithLabelFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
                Expression<Func<TModel, TProperty>> hourExpression, Expression<Func<TModel, TProperty>> minuteExpression,
                HtmlAttributes labelHourHtmlAttributes, HtmlAttributes dropDownHourHtmlAttributes,
                HtmlAttributes labelMinuteHtmlAttributes, HtmlAttributes dropDownMinuteHtmlAttributes)
        {
            IDictionary<string, object> newLabelAttributesHour = null;
            if (labelHourHtmlAttributes != null)
                newLabelAttributesHour = labelHourHtmlAttributes.BuildAttributes();

            if (dropDownHourHtmlAttributes != null && !dropDownHourHtmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            IDictionary<string, object> newDropDownAttributesHour = null;
            if (dropDownHourHtmlAttributes != null)
                newDropDownAttributesHour = dropDownHourHtmlAttributes.BuildAttributes();

            IDictionary<string, object> newLabelAttributesMinute = null;
            if (labelMinuteHtmlAttributes != null)
                newLabelAttributesMinute = labelMinuteHtmlAttributes.BuildAttributes();

            if (dropDownMinuteHtmlAttributes != null && !dropDownMinuteHtmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            IDictionary<string, object> newDropDownAttributesMinute = null;
            if (dropDownMinuteHtmlAttributes != null)
                newDropDownAttributesMinute = dropDownMinuteHtmlAttributes.BuildAttributes();

            var memberH = (MemberExpression)hourExpression.Body;
            var memberM = (MemberExpression)minuteExpression.Body;
            var param = Expression.Parameter(typeof(TProperty), "value");
            var setH = Expression.Lambda<Action<TModel, TProperty>>(
                Expression.Assign(memberH, param), hourExpression.Parameters[0], param);
            var setM = Expression.Lambda<Action<TModel, TProperty>>(
                Expression.Assign(memberM, param), minuteExpression.Parameters[0], param);

            // compile it
            var actionH = setH.Compile();
            var actionM = setM.Compile();
            var model = htmlHelper.ViewData.Model;
            TProperty propertyH = hourExpression.Compile()(model);
            TProperty propertyM = minuteExpression.Compile()(model);

            //should be string, but double check
            //set the hour value to the D2 format if not set already
            if (propertyH is string)
            {
                string value = (string)Convert.ChangeType(propertyH, typeof(string));
                if (value.Length == 1)
                {
                    value = "0" + value;
                    actionH(model, (TProperty)Convert.ChangeType(value, typeof(TProperty)));
                }
            }
            //set the minute value to the D2 format if not set already
            if (propertyM is string)
            {
                string value = (string)Convert.ChangeType(propertyM, typeof(string));
                if (value.Length == 1)
                {
                    value = "0" + value;
                    actionM(model, (TProperty)Convert.ChangeType(value, typeof(TProperty)));
                }
            }

            string res = InputHelpers.LabelFor(htmlHelper, hourExpression, "H", newLabelAttributesHour) + " " + SelectExtensions.DropDownListFor(htmlHelper, hourExpression, new SelectList(TimeLists.HourList), newDropDownAttributesHour).ToString() +
             " " + InputHelpers.LabelFor(htmlHelper, minuteExpression, "M", newLabelAttributesMinute) + " " + SelectExtensions.DropDownListFor(htmlHelper, minuteExpression, new SelectList(TimeLists.MinuteList), newDropDownAttributesMinute).ToString();

            return MvcHtmlString.Create(res);
        }

        public static MvcHtmlString CustomDateTimePickerFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
                Expression<Func<TModel, TProperty>> hourExpression, Expression<Func<TModel, TProperty>> minuteExpression, Expression<Func<TModel, TProperty>> secondExpression)
        {
            string res = SelectExtensions.DropDownListFor(htmlHelper, hourExpression, new SelectList(TimeLists.HourList)).ToString() +
             ":" + SelectExtensions.DropDownListFor(htmlHelper, minuteExpression, new SelectList(TimeLists.MinuteList)).ToString() +
             ":" + SelectExtensions.DropDownListFor(htmlHelper, secondExpression, new SelectList(TimeLists.SecondList)).ToString();

            return MvcHtmlString.Create(res);
        }

        public static MvcHtmlString CustomDateTimePickerWithLabelFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
                Expression<Func<TModel, TProperty>> hourExpression, Expression<Func<TModel, TProperty>> minuteExpression, Expression<Func<TModel, TProperty>> secondExpression)
        {
            string res = LabelExtensions.LabelFor(htmlHelper, hourExpression, "H") + " " +
                         SelectExtensions.DropDownListFor(htmlHelper, hourExpression, new SelectList(TimeLists.HourList)).ToString() + " " +
                         LabelExtensions.LabelFor(htmlHelper, minuteExpression, "M") + " " +
                         SelectExtensions.DropDownListFor(htmlHelper, minuteExpression, new SelectList(TimeLists.MinuteList)).ToString() + " " +
                         LabelExtensions.LabelFor(htmlHelper, secondExpression, "S") + " " +
                         SelectExtensions.DropDownListFor(htmlHelper, secondExpression, new SelectList(TimeLists.SecondList)).ToString();

            return MvcHtmlString.Create(res);
        }

        /// <summary>
        /// a html helper for rendering a control for data entering
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// <param name="htmlAttributes">other html atribubes</param>
        /// <returns>a html representing a text box and a button to open a calendar</returns>
        public static MvcHtmlString CustomDatePickerFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression,
            HtmlAttributes htmlAttributes)
        {
            if (htmlAttributes == null)
                htmlAttributes = new HtmlAttributes();

            if (!htmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            var newAttributes = htmlAttributes.BuildAttributesForDateTime();

            if (!htmlAttributes.IsEnabled)
                return InputExtensions.TextBoxFor<TModel, TProperty>(htmlHelper, expression, newAttributes);

            var res = InputExtensions.TextBoxFor<TModel, TProperty>(htmlHelper, expression, newAttributes).ToHtmlString()
                + htmlAttributes.CalendarButton;
            return MvcHtmlString.Create(res);
        }

        /// <summary>
        /// Renders a custom progress bar control. The int value ranges from 0 to 100.
        /// </summary>
        /// <typeparam name="TModel">The type of model to bind to.</typeparam>
        /// <typeparam name="TProperty">The type of the property.</typeparam>
        /// <param name="htmlHelper">The html helper used to render the control.</param>
        /// <param name="value">The value.</param>
        /// <param name="htmlAttributes">Other html atribubes.</param>
        /// <returns>
        /// A html representing a progressbar.
        /// </returns>
        public static MvcHtmlString CustomProgressBar(this HtmlHelper htmlHelper, int value, HtmlAttributes htmlAttributes = null)
        {
            return MvcHtmlString.Create(GetCustomProgressBarHtml(htmlAttributes, value));
        }

        /// <summary>
        /// Renders a custom progress bar control. The int value ranges from 0 to 100.
        /// </summary>
        /// <typeparam name="TModel">The type of model to bind to.</typeparam>
        /// <typeparam name="int">The type of the property of the model to bind to.</typeparam>
        /// <param name="htmlHelper">The html helper used to render the control.</param>
        /// <param name="expression">The expression representing the model and property to bind to.</param>
        /// <param name="htmlAttributes">Other html atribubes.</param>
        /// <returns>A html representing a progressbar.</returns>
        public static MvcHtmlString CustomProgressBarFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper, Expression<Func<TModel, TProperty>> expression,
            HtmlAttributes htmlAttributes = null)
        {
            var model = htmlHelper.ViewData.Model;
            int value = 0;
            float fValue = 0;
            if (typeof(TProperty) == typeof(int))
                value = (int)Convert.ChangeType(expression.Compile()(model), typeof(int));
            else if (typeof(TProperty) == typeof(float))
                value = (int)((float)Convert.ChangeType(expression.Compile()(model), typeof(float)) * 100);
            else
                if (typeof(TProperty) == typeof(string))
                    if (float.TryParse((string)Convert.ChangeType(expression.Compile()(model), typeof(string)), out fValue))
                        value = (int)(fValue * 100);
                    else
                        throw new ArgumentException("Expression member must be of type int or float", "expression");
            return MvcHtmlString.Create(GetCustomProgressBarHtml(htmlAttributes, value));
        }

        private static string GetCustomProgressBarHtml(HtmlAttributes htmlAttributes, int value)
        {
            if (value > 100)
                value = 100;
            if (value < 0)
                value = 0;
            if (htmlAttributes == null)
                htmlAttributes = new HtmlAttributes();
            if (string.IsNullOrEmpty(htmlAttributes.Style))
                htmlAttributes.Style = "";
            if (!htmlAttributes.Style.Contains("height"))
                htmlAttributes.Style += @" height: 14px";
            if (string.IsNullOrEmpty(htmlAttributes.CSSClass))
                htmlAttributes.CSSClass = "progress";
            else
                htmlAttributes.CSSClass += " progress";

            string res = @"<div data-value=" + value + " " + HtmlAttributes.GetAttributes(htmlAttributes.BuildAttributesId()) + @">
                            <span>" + value + @"%</span>
                           </div>" + htmlAttributes.ProgressBar;

            return res;
        }
        /// <summary>
        /// a html helper for rendering a control for data entering
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// <returns>a html representing a text box and a button to open a calendar</returns>
        public static MvcHtmlString CustomDatePickerFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
                Expression<Func<TModel, TProperty>> expression)
        {
            return InputHelpers.CustomDatePickerFor(htmlHelper, expression, null);
        }

        /// <summary>
        /// a html helper for rendering a check-box
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// /// <param name="htmlAttributes">other html atribubes</param>
        /// <returns>a html representing a check box </returns>
        public static MvcHtmlString CustomCheckBoxFor<TModel>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, bool>> expression, HtmlAttributes htmlAttributes)
        {
            if (htmlAttributes == null)
                return InputExtensions.CheckBoxFor<TModel>(htmlHelper, expression);

            if (!htmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            var newAttributes = htmlAttributes.BuildAttributes();
            return InputExtensions.CheckBoxFor<TModel>(htmlHelper, expression, newAttributes);
        }

        /// <summary>
        /// a html helper for rendering a label
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TValue">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// <param name="labelText"></param>
        /// /// <param name="htmlAttributes">other html atribubes</param>
        /// <returns>a html representing a label </returns>
        public static MvcHtmlString CustomLabelFor<TModel, TValue>(this HtmlHelper<TModel> html,
            Expression<Func<TModel, TValue>> expression, string labelText, object htmlAttributes)
        {
            if (htmlAttributes == null)
                return LabelExtensions.LabelFor<TModel, TValue>(html, expression, labelText);

            return LabelFor(html, expression, labelText, new RouteValueDictionary(htmlAttributes));
        }

        /// <summary>
        /// Html helper for rendering a label.
        /// </summary>
        /// <typeparam name="TModel">The type of model to bind to.</typeparam>
        /// <typeparam name="TValue">The type of the property of the model to bind to.</typeparam>
        /// <param name="html">The html helper used to render the control.</param>
        /// <param name="expression">The expression representing the model and property to bind to.</param>
        /// <param name="labelText">The label text.</param>
        /// <param name="htmlAttributes">The HTML attributes.</param>
        /// <returns></returns>
        private static MvcHtmlString LabelFor<TModel, TValue>(this HtmlHelper<TModel> html,
            Expression<Func<TModel, TValue>> expression, string labelText, IDictionary<string, object> htmlAttributes)
        {
            string htmlFieldName = ExpressionHelper.GetExpressionText(expression);

            if (String.IsNullOrEmpty(labelText))
            {
                return MvcHtmlString.Empty;
            }

            TagBuilder tag = new TagBuilder("label");
            tag.MergeAttributes(htmlAttributes);
            if (!htmlAttributes.ContainsKey("for"))
            {
                tag.Attributes.Add("for", html.ViewContext.ViewData.TemplateInfo.GetFullHtmlFieldId(htmlFieldName));
            }
            
            tag.SetInnerText(labelText);

            return MvcHtmlString.Create(tag.ToString(TagRenderMode.Normal));
        }

        /// <summary>
        /// a html helper for rendering a text box
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// /// <param name="htmlAttributes">other html atribubes</param>
        /// <returns>a html representing a text box </returns>
        public static MvcHtmlString CustomTextBoxFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression, HtmlAttributes htmlAttributes)
        {
            if (htmlAttributes == null)
                return InputExtensions.TextBoxFor<TModel, TProperty>(htmlHelper, expression);

            if (!htmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            var newAttributes = htmlAttributes.BuildAttributesForTextBox();
            htmlHelper.ChangeXssValue(expression);
            return InputExtensions.TextBoxFor<TModel, TProperty>(htmlHelper, expression, newAttributes);
        }

        /// <summary>
        /// a html helper for rendering a combo box
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// /// <param name="htmlAttributes">other html atribubes</param>
        /// <returns>a html representing a combo box </returns>
        public static MvcHtmlString CustomDropDownListFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression,
            IEnumerable<SelectListItem> selectList, string optionLabel, HtmlAttributes htmlAttributes)
        {
            if (htmlAttributes == null)
                return SelectExtensions.DropDownListFor<TModel, TProperty>(htmlHelper, expression, selectList);

            if (!htmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            var newAttributes = htmlAttributes.BuildAttributes();
            if (optionLabel != null)
                return SelectExtensions.DropDownListFor<TModel, TProperty>(htmlHelper, expression, selectList, optionLabel, newAttributes);
            else
                return SelectExtensions.DropDownListFor<TModel, TProperty>(htmlHelper, expression, selectList, newAttributes);
        }

        /// <summary>
        /// a html helper for rendering a combo box
        /// </summary>
        /// <typeparam name="TModel">the type of model to bind to</typeparam>
        /// <typeparam name="TProperty">the type of the property of the model to bind to</typeparam>
        /// <param name="htmlHelper">the html helper used to render the control</param>
        /// <param name="expression">the expression representing the model and property to bind to</param>
        /// /// <param name="htmlAttributes">other html atribubes</param>
        /// <returns>a html representing a combo box </returns>
        public static MvcHtmlString CustomDropDownListFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression,
            IEnumerable<SelectListItem> selectList, HtmlAttributes htmlAttributes)
        {
            return htmlHelper.CustomDropDownListFor(expression, selectList, null, htmlAttributes);
        }

        public static MvcHtmlString CustomXssDropDownListFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression,
            IEnumerable<SelectListItem> selectList, HtmlAttributes htmlAttributes)
        {
            return htmlHelper.CustomXssDropDownListFor(expression, selectList, null, htmlAttributes);
        }

        public static MvcHtmlString CustomXssDropDownListFor<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression,
            IEnumerable<SelectListItem> selectList, string optionLabel, HtmlAttributes htmlAttributes)
        {
            IEnumerable<SelectListItem> newSelectList = selectList.Select<SelectListItem, SelectListItem>(a => new SelectListItem() { Selected = a.Selected, Value = a.Value, Text = xssEncoder.Decode(a.Text) });
            return htmlHelper.CustomDropDownListFor(expression, newSelectList, optionLabel, htmlAttributes);
        }

        public static readonly string FormNameKey = "FormName";
        public static MvcHtmlString NamedValidationSummary(this HtmlHelper htmlHelper, string name)
        {

            if (htmlHelper.ViewData[FormNameKey] != null && !string.IsNullOrEmpty(htmlHelper.ViewData[FormNameKey].ToString()) && (htmlHelper.ViewData[FormNameKey].ToString() == name))
                return htmlHelper.ValidationSummary();

            return MvcHtmlString.Create(null);
        }

        /// <summary>
        /// Generates routevalues and controller and action strings from a strong typed lambda expression of a controllermethod.
        /// </summary>
        /// <typeparam name="T">Must be a Controller</typeparam>
        /// <param name="routeValues">Can be null or empty, but you can supply extra routevalues these win if generated values overlap</param>
        /// <param name="actionSelector">a lambda expression, must be a call to a ActionResult returning method</param>
        /// <param name="controller">the name of the controller</param>
        /// <param name="action">the name of the action</param>
        /// <returns></returns>
        public static RouteValueDictionary GetRouteValues<T>(
            RouteValueDictionary routeValues,
            Expression<Func<T, ActionResult>> actionSelector,
            out string controller,
            out string action)
        {
            Type controllerType = typeof(T);
            if (routeValues == null)
            {
                routeValues = new RouteValueDictionary();
            }

            //The body of the expression must be a call to a method
            MethodCallExpression call = actionSelector.Body as MethodCallExpression;
            if (call == null)
            {
                throw new ArgumentException("You must call a method of " + controllerType.Name, "actionSelector");
            }

            //the object being called must be the controller specified in <T>
            if (call.Object.Type != controllerType)
            {
                throw new ArgumentException("You must call a method of " + controllerType.Name, "actionSelector");
            }

            //Remove the controller part of the name ProductController --> Product
            if (controllerType.Name.EndsWith("Controller"))
            {
                controller = controllerType.Name.Substring(0, controllerType.Name.Length - "Controller".Length);
            }
            else
            {
                controller = controllerType.Name;
            }
            //The action is the name of the method being called
            action = call.Method.Name;

            //get all arguments from the lambda expression
            var args = call.Arguments;

            //Get all parameters from the Action Method
            ParameterInfo[] parameters = call.Method.GetParameters();

            //pair the lambda arguments with the param names
            var pairs = args.Select((a, i) => new
                                              {
                                                  Argument = a,
                                                  ParamName = parameters[i].Name
                                              });


            foreach (var argumentParameterPair in pairs)
            {
                string name = argumentParameterPair.ParamName;
                if (!routeValues.ContainsKey(name))
                {
                    //the argument could be a constant or a variable or a function and must be evaluated
                    object value = null;
                    //If it is a constant we can get the value immediately
                    if (argumentParameterPair.Argument.NodeType == ExpressionType.Constant)
                    {
                        var constant = argumentParameterPair.Argument as ConstantExpression;
                        if (constant != null) {
                        	value = constant.Value;
                        }
                    }
                    else //if not we have to evaluate the value
                    {

                        value = Expression.Lambda(argumentParameterPair.Argument).Compile().DynamicInvoke(null);
                    }
                    if (value != null)
                    {
                        //add routevalues with the name = method parameter name (productSlug) and value = the evaluated lambda value
                        routeValues.Add(name, value);
                    }
                }
            }

            return routeValues;
        }
    }

    /// <summary>
    /// a class for specifying the html atributes for controls
    /// </summary>
    public class HtmlAttributes
    {
        public HtmlAttributes(string CssClass)
            : this()
        {
            this.CSSClass = CssClass;
        }

        public HtmlAttributes()
        {
            IsVisible = true;
            IsEnabled = true;
            IsReadOnly = false;
        }

        /// <summary>
        /// the html css attribute
        /// </summary>
        public string CSSClass { get; set; }
        /// <summary>
        /// the html style attribute
        /// </summary>
        public string Style { get; set; }
        /// <summary>
        /// the html disabled attribute
        /// </summary>
        public bool IsEnabled { get; set; }
        /// <summary>
        /// if true the control is not rendered
        /// </summary>
        public bool IsVisible { get; set; }

        /// <summary>
        /// Gets or sets the maximum length.
        /// </summary>
        /// <value>
        /// The maximum length.
        /// </value>
        public int? MaximumLength { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is read only.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is read only; otherwise, <c>false</c>.
        /// </value>
        public bool IsReadOnly { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [auto complete].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [auto complete]; otherwise, <c>false</c>.
        /// </value>
        public bool? AutoComplete { get; set; }

        /// <summary>
        /// Gets or sets the access key.
        /// </summary>
        /// <value>
        /// The access key.
        /// </value>
        public string AccessKey { get; set; }

        /// <summary>
        /// Gets or sets the title.
        /// </summary>
        /// <value>
        /// The title.
        /// </value>
        public string Title { get; set; }

        public string Id { get; set; }

        public string For { get; set; }
       
        internal IDictionary<string, object> BuildAttributes()
        {
            var newAttributes = new Dictionary<string, object>();
            if (!this.IsEnabled)
                newAttributes.Add("disabled", "disabled");
            if (this.IsReadOnly)
                newAttributes.Add("readonly", "readonly");
            if (!string.IsNullOrWhiteSpace(this.CSSClass))
                newAttributes.Add("class", this.CSSClass);
            if (!string.IsNullOrWhiteSpace(this.Style))
                newAttributes.Add("style", this.Style);
            if (!string.IsNullOrWhiteSpace(this.AccessKey))
                newAttributes.Add("accesskey", this.AccessKey);
            if (!string.IsNullOrEmpty(this.Title))
                newAttributes.Add("title", this.Title);
            if (!string.IsNullOrEmpty(this.Id))
                newAttributes.Add("id", this.Id);
            if (!string.IsNullOrEmpty(this.For))
                newAttributes.Add("for", this.For);
            return newAttributes;
        }

        internal IDictionary<string, object> BuildAttributesId()
        {
            var newAttributes = BuildAttributes();
            newAttributes.Add("id", id++);
            return newAttributes;
        }

        internal IDictionary<string, object> BuildAttributesForTextBox()
        {
            var newAttributes = new Dictionary<string, object>();
            if (!string.IsNullOrEmpty(Id))
                newAttributes.Add("id", this.Id);
            if (!this.IsEnabled)
                newAttributes.Add("disabled", "disabled");
            if (this.IsReadOnly)
                newAttributes.Add("readonly", "readonly");
            if (string.IsNullOrWhiteSpace(this.CSSClass))
                this.CSSClass = "textUppercase";
            else
            {
                if (!this.CSSClass.Contains("textNoTransform"))
                    this.CSSClass += " textUppercase";
            }
            newAttributes.Add("class", this.CSSClass);
            if (!string.IsNullOrWhiteSpace(this.Style))
                newAttributes.Add("style", this.Style);
            if (this.MaximumLength != null)
            {
                newAttributes.Add("size", this.MaximumLength);
                newAttributes.Add("maxlength", this.MaximumLength);
            }
            if (!string.IsNullOrWhiteSpace(this.AccessKey))
                newAttributes.Add("accesskey", this.AccessKey);
            if (!string.IsNullOrEmpty(this.Title))
                newAttributes.Add("title", this.Title);
            if (this.AutoComplete.HasValue)
            {
                if (this.AutoComplete.Value)
                    newAttributes.Add("autocomplete", "on");
                else
                    newAttributes.Add("autocomplete", "off");
            }

            return newAttributes;
        }

        internal IDictionary<string, object> BuildAttributesFroMultipleValuesControl()
        {
            var newAttributes = new Dictionary<string, object>();
            if (!this.IsEnabled)
                newAttributes.Add("disabled", "disabled");
            if (string.IsNullOrWhiteSpace(this.CSSClass))
                this.CSSClass = "textUppercase cssAutoComplete";
            else
            {
                if (!this.CSSClass.Contains("textNoTransform"))
                    this.CSSClass += " textUppercase cssAutoComplete";
                else
                    this.CSSClass += " cssAutoComplete";
            }
            newAttributes.Add("class", this.CSSClass);
            if (!string.IsNullOrWhiteSpace(this.Style))
                newAttributes.Add("style", this.Style);
            if (this.MaximumLength != null)
            {
                newAttributes.Add("size", this.MaximumLength);
                newAttributes.Add("maxlength", this.MaximumLength);
            }
            if (!string.IsNullOrWhiteSpace(this.AccessKey))
                newAttributes.Add("accesskey", this.AccessKey);
            if (!string.IsNullOrWhiteSpace(this.Id))
                newAttributes.Add("Id", this.Id);

            return newAttributes;
        }

        internal IDictionary<string, object> BuildAttributesForDateTime()
        {
            var newAttributes = new Dictionary<string, object>();

            if (!string.IsNullOrWhiteSpace(this.Style))
                newAttributes.Add("style", this.Style);

            if (!this.IsEnabled)
                newAttributes.Add("disabled", "disabled");
            else
                newAttributes.Add("class", ControlName);

            if (!string.IsNullOrWhiteSpace(this.AccessKey))
                newAttributes.Add("accesskey", this.AccessKey);

            if (!string.IsNullOrEmpty(this.Title))
                newAttributes.Add("title", this.Title);

            return newAttributes;
        }

        string _ControlName = null;
        private string ControlName
        {
            get
            {
                if (_ControlName == null)
                    _ControlName = "datep" + nameSufix++;
                return _ControlName;
            }
        }

        internal string CalendarButton
        {
            get
            {
                return "<button accesskey=\"" + CalendarButtonAccessKey + "\" class=\"ui-datepicker-trigger\" id=\"button" + ControlName + "\" type=\"button\">...</button>";
            }
        }

        internal string ProgressBar
        {
            get
            {
                return @"<script language=""text/javascript"" type=""text/javascript"">
                            $("".progress"").each(function(){var c=$(this).data(""value""),b,a;if(c<50){b='LightGreen';a='Black'}else if(c<85){b='Yellow';a='Black'}else{b='Red';a='Black'}$(this).progressbar({value:c}).children(""span"").css(""color"",a).appendTo(this);$('#'+$(this).attr('id')+' > div').css('background',b)});
                         </script>";
            }
        }

        internal static string GetAttributes(IDictionary<string, object> htmlAttributes)
        {
            string result = "";
            if (htmlAttributes != null)
                foreach (KeyValuePair<string, object> attribute in htmlAttributes)
                    result += attribute.Key + @"=""" + attribute.Value.ToString() + @""" ";
            return result;
        }

        private static int nameSufix = 1;
        private static int id = 1;
        private static int _calendarButtonAccessKey = -1;
        internal static int CalendarButtonAccessKey
        {
            get
            {
                if (_calendarButtonAccessKey > 8)
                    _calendarButtonAccessKey = -1;
                _calendarButtonAccessKey++;
                return _calendarButtonAccessKey;
            }
        }
    }

    /// <summary>
    /// class for html helpers and utilities custom to BMS business
    /// </summary>
    public static class CustomHelpers
    {
        static AntiXssEncoder xssEncoder = new AntiXssEncoder();

        /// <summary>
        /// sets the class atribute for a row in a table to generate an alternate style
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="rowIndex">the index of the row</param>
        /// <returns> a html markup for seting the alternate style for this row</returns>
        public static MvcHtmlString SetRowClass(this HtmlHelper helper, int rowIndex)
        {
            return MvcHtmlString.Create(rowIndex % 2 == 0 ? "class=\"colorLine\"" : null);
        }

        public static MvcHtmlString SetRowClassCustom(this HtmlHelper helper, int rowIndex)
        {
            if (rowIndex == 0)
                return MvcHtmlString.Create("class=\"first\"");
            else
                return MvcHtmlString.Create(null);
        }

        public static MvcHtmlString SetRowClassEMS(this HtmlHelper helper, int rowIndex, string manualRequest)
        {
            if (manualRequest.ToLower().Contains("manual"))
            {
                if (manualRequest.ToLower().Contains("stat"))
                    return MvcHtmlString.Create("class=\"colorRed alignCenter\"");
                else
                    return MvcHtmlString.Create("class=\"colorYellow alignCenter\"");
            }
            else
                return MvcHtmlString.Create("class=\"alignCenter\"");
        }

        /// <summary>
        /// Sets the class attribute for a row of the waiting list table.
        /// </summary>
        /// <param name="helper">The helper just for extension purpose.</param>
        /// <param name="currentFilter">The current filter button.</param>
        /// <param name="roomBedAssigned">The room bed assigned.</param>
        /// <param name="rowIndex">Index of the row.</param>
        /// <returns>A html markup for seting the style for this row.</returns>
        public static MvcHtmlString SetWaitingListRowClass(this HtmlHelper helper, string currentFilter, string roomBedAssigned, int rowIndex)
        {
            string classColor = string.Empty;

            if (!string.IsNullOrEmpty(roomBedAssigned) && currentFilter.Equals(Strings.WaitingList_Current))
                classColor = "class=\"colorLineOrange\"";

            return MvcHtmlString.Create(classColor);
        }

        /// <summary>
        /// Alls the images for.
        /// </summary>
        /// <param name="helper">The helper.</param>
        /// <param name="imageList">The image list.</param>
        /// <param name="valign">The valign.</param>
        /// <returns></returns>
        public static MvcHtmlString AllImagesFor(this HtmlHelper helper, IList<IconInfo> imageList, string valign)
        {
            StringBuilder res = new StringBuilder();
            if (imageList != null && imageList.Count > 0)
            {
                foreach (IconInfo icon in imageList)
                {
                    res.Append(GetImageWithStyleFor(icon.ImageBytes, icon.MouseOverText, icon.ImageName, null, null, valign, null));
                }
            }
            return MvcHtmlString.Create(res.ToString());
        }
        /// <summary>
        /// renders the image in the CDWithProperties list with a specified name
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageList">the list of Cd's where images are stored</param>
        /// <param name="imageName">the name of the CD which holds the image</param>
        /// <returns>a html representing the image</returns>
        public static MvcHtmlString ImageFor(this HtmlHelper helper, string imageName, IList<CDWithProperties> imageList)
        {
            CDWithProperties item = imageList.FirstOrDefault(x => x.code == imageName);
            return MvcHtmlString.Create(GetImageFor(item, "Icon"));
        }
        /// <summary>
        /// renders the image stored in a CDWithProperties with a property specified 
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageList">the Cd where image is stored</param>
        /// <param name="imageName">the name of the property in CD which holds the image</param>
        /// <returns>a html representing the image</returns>
        public static MvcHtmlString ImageFor(this HtmlHelper helper, CDWithProperties cdproperties, string propertyName)
        {
            return MvcHtmlString.Create(GetImageFor(cdproperties, propertyName));
        }
        private static String GetImageFor(CDWithProperties cdproperties, string propertyName)
        {
            StringBuilder sbImage = new StringBuilder();
            if (cdproperties != null)
            {
                if (cdproperties.Properties != null)
                {
                    var conceptProperty = cdproperties.Properties.Find(cp => cp.PropertyName.text == propertyName);
                    if (conceptProperty != null)
                    {
                        bool isIE7 = Utilities.IsIE7Browser();
                        if (!isIE7)
                        {
                            sbImage.Append("<img src=\"data:image/png;base64,");
                            sbImage.Append(conceptProperty.PropertyValue.text);
                            sbImage.Append("\" alt=\"\" />");
                        }
                        else
                        {
                            StringBuilder imageName = new StringBuilder();
                            imageName.Append(cdproperties.codeSystemName);
                            imageName.Append("_");
                            imageName.Append(cdproperties.code);
                            imageName.Append(".png");
                            ImageConverter.GetImageFromByteArray(conceptProperty.PropertyValue.text, imageName.ToString());
                            sbImage.Append("<img src=\"");
                            sbImage.Append(ImageConverter.GetImageRelativePath());
                            sbImage.Append(imageName.ToString());
                            sbImage.Append("\" alt=\"\" />");
                        }
                    }
                }
            }
            return sbImage.ToString();
        }

        /// <summary>
        /// renders the image
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageBytes">the image bytes</param>
        /// <param name="mouseOverText">the text for alt</param>
        /// <param name="imageName">the image name</param>
        /// <returns>a html representing the image</returns>
        public static MvcHtmlString ImageFor(this HtmlHelper helper, string imageBytes, string mouseOverText, string imageName)
        {
            return MvcHtmlString.Create(GetImageWithStyleFor(imageBytes, mouseOverText, imageName, null, null, null, null));
        }

        /// <summary>
        /// renders the image
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageBytes">the image bytes</param>
        /// <param name="mouseOverText">the text for alt</param>
        /// <param name="imageName">the image name</param>
        /// <param name="width">the image width</param>
        /// <param name="height">the image height</param>
        /// <returns>a html representing the image</returns>
        public static MvcHtmlString ImageFor(this HtmlHelper helper, string imageBytes, string mouseOverText, string imageName, int width, int height)
        {
            return MvcHtmlString.Create(GetImageWithStyleFor(imageBytes, mouseOverText, imageName, width, height, null, null));
        }

        /// <summary>
        /// renders the image
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageBytes">the image bytes</param>
        /// <param name="mouseOverText">the text for alt</param>
        /// <param name="imageName">the image name</param>
        /// <param name="width">the image width</param>
        /// <param name="height">the image height</param>
        /// <param name="valign">the image valign</param>
        /// <returns>a html representing the image</returns>
        public static MvcHtmlString ImageFor(this HtmlHelper helper, string imageBytes, string mouseOverText, string imageName, int width, int height, string valign)
        {
            return MvcHtmlString.Create(GetImageWithStyleFor(imageBytes, mouseOverText, imageName, width, height, valign, null));
        }

        /// <summary>
        /// renders the image
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageBytes">the image bytes</param>
        /// <param name="mouseOverText">the text for alt</param>
        /// <param name="imageName">the image name</param>        
        /// <param name="valign">the image valign</param>
        /// <returns>a html representing the image</returns>
        public static MvcHtmlString ImageFor(this HtmlHelper helper, string imageBytes, string mouseOverText, string imageName, string valign)
        {
            return MvcHtmlString.Create(GetImageWithStyleFor(imageBytes, mouseOverText, imageName, null, null, valign, null));
        }

        /// <summary>
        /// renders the image
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageBytes">the image bytes</param>
        /// <param name="mouseOverText">the text for alt</param>
        /// <param name="imageName">the image name</param>        
        /// <param name="valign">the image valign</param>
        /// <returns>a html representing the image</returns>
        public static MvcHtmlString ImageFor(this HtmlHelper helper, string imageBytes, string mouseOverText, string imageName, string valign, bool? isPublished)
        {
            return MvcHtmlString.Create(GetImageWithStyleFor(imageBytes, mouseOverText, imageName, null, null, valign, isPublished));
        }

        /// <summary>
        /// renders the image
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="imageBytes">the image bytes</param>
        /// <param name="mouseOverText">the text for alt</param>
        /// <param name="imageName">the image name</param>
        /// <param name="width">the image width</param>
        /// <param name="height">the image height</param>
        /// <returns>a html representing the image</returns>
        public static String GetImageWithStyleFor(string imageBytes, string mouseOverText, string imageName, int? width, int? height, string valign, bool? isPublished)
        {
            StringBuilder sbImage = new StringBuilder();
            if (!string.IsNullOrEmpty(imageBytes))
            {
                //bool isIE7 = Utilities.IsIE7Browser();
                //if (!isIE7)
                //{
                //    sbImage.Append("<img src=\"data:image/png;base64,");
                //    sbImage.Append(imageBytes);
                //}
                //else
                //{
                StringBuilder imgName = new StringBuilder();
                imgName.Append(imageName.Replace(System.IO.Path.GetExtension(imageName), string.Empty));
                if (isPublished.HasValue && isPublished.Value == false)
                    imgName.Append("_inactive");
                imgName.Append(".png");
                ImageConverter.GetImageFromByteArray(imageBytes, imgName.ToString());
                sbImage.Append("<img src=\"");
                sbImage.Append(ImageConverter.GetImageRelativePath());
                sbImage.Append(imgName);
                //}
                sbImage.Append("\" alt=\"");
                sbImage.Append(mouseOverText);
                sbImage.Append("\" title=\"");
                sbImage.Append(mouseOverText);
                sbImage.Append("\"");
                if (width != null || height != null || !string.IsNullOrEmpty(valign))
                    sbImage.Append(" style=\"");
                if (width != null)
                {
                    sbImage.Append("width:");
                    sbImage.Append(width.ToString());
                    sbImage.Append("px;");
                }
                if (height != null)
                {
                    sbImage.Append("height:");
                    sbImage.Append(height.ToString());
                    sbImage.Append("px;");
                }
                if (!string.IsNullOrEmpty(valign))
                {
                    sbImage.Append("vertical-align:");
                    sbImage.Append(valign);
                    sbImage.Append(";");
                }
                if (width != null || height != null || !string.IsNullOrEmpty(valign))
                    sbImage.Append("\"");
                sbImage.Append(" />");
            }
            return sbImage.ToString();
        }

        /// <summary>
        /// helper for generating html attributes used for rendering ui elements depending on gender
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="gender">the gender</param>
        /// <returns>the html markup for attributes</returns>
        public static MvcHtmlString CenterClassFor(this HtmlHelper helper, string gender)
        {
            if (gender == "Male")
                return MvcHtmlString.Create("class=\"colorBlue alignCenter\"");
            else
                return MvcHtmlString.Create("class=\"colorPink alignCenter\"");
        }
        /// <summary>
        /// helper for generating html attributes used for rendering ui elements depending on gender
        /// </summary>
        /// <param name="helper">helper just for extension purpose</param>
        /// <param name="gender">the gender</param>
        /// <returns>the html markup for attributes</returns>
        public static MvcHtmlString RightClassFor(this HtmlHelper helper, string gender)
        {
            if (gender == "Male")
                return MvcHtmlString.Create("class=\"colorBlue alignRight\"");
            else
                return MvcHtmlString.Create("class=\"colorPink alignRight\"");
        }

        /// <summary>
        /// helper for generating html attributes used for rendering ui elements depending on gender, unavailableTypeCode and unavailableReasonDisplayName
        /// </summary>
        /// <param name="helper">The helper.</param>
        /// <param name="unavailableTypeCode">The unavailable type code.</param>
        /// <param name="unavailableReasonCode">The unavailable reason display name.</param>
        /// <param name="gender">The gender.</param>
        /// <returns></returns>
        public static MvcHtmlString CenterClassFor(this HtmlHelper helper, CD bedAvailabilityStatus, string unavailableReasonDisplayName, string gender)
        {
            string classColor = string.Empty;
            if (unavailableReasonDisplayName.Contains("TEMPORARILY UNAVAILABLE") || (bedAvailabilityStatus != null && (bedAvailabilityStatus.code == "OOS" || bedAvailabilityStatus.code == "DND" || bedAvailabilityStatus.code == "BED_OOS_VISTA" || bedAvailabilityStatus.code == "BED_OOS_BEDBOARD")))
                classColor = "class=\"colorRed alignCenter\"";
            else if (unavailableReasonDisplayName.Contains("BED ASSIGNED") || unavailableReasonDisplayName.Contains(Constants.BED_HOLD_TEXT))
                classColor = "class=\"colorOrange alignCenter\"";
            else
                classColor = "class=\"colorYellowOrange alignCenter\"";

            if (!string.IsNullOrEmpty(gender))
            {
                if (gender == "Male")
                    classColor = "class=\"colorBlue alignCenter\"";
                else
                    classColor = "class=\"colorPink alignCenter\"";
            }
            return MvcHtmlString.Create(classColor);
        }

        /// <summary>
        /// helper for generating html attributes used for rendering ui elements depending on gender, unavailableTypeCode and unavailableReasonDisplayName
        /// </summary>
        /// <param name="helper">The helper.</param>
        /// <param name="bedAvailabilityStatus">The bed availability status.</param>
        /// <param name="unavailableReasonDisplayName">Display name of the unavailable reason.</param>
        /// <param name="gender">The gender.</param>
        /// <returns></returns>
        public static MvcHtmlString CenterClassFor(this HtmlHelper helper, string bedAvailabilityStatusCode, string unavailableReasonDisplayName, string gender)
        {
            CD bedAvailabilityStatus = null;
            if (!string.IsNullOrEmpty(bedAvailabilityStatusCode))
                bedAvailabilityStatus = new CD() { code = bedAvailabilityStatusCode };

            return CenterClassFor(helper, bedAvailabilityStatus, unavailableReasonDisplayName, gender);
        }

        /// <summary>
        /// helper for generating html attributes used for rendering ui elements depending on gender, unavailableTypeCode and unavailableReasonDisplayName
        /// </summary>
        /// <param name="helper">The helper.</param>
        /// <param name="unavailableTypeCode">The unavailable type code.</param>
        /// <param name="unavailableReasonDisplayName">Display name of the unavailable reason.</param>
        /// <param name="gender">The gender.</param>
        /// <returns></returns>
        public static MvcHtmlString RightClassFor(this HtmlHelper helper, CD bedAvailabilityStatus, string unavailableReasonDisplayName, string gender)
        {
            string classColor = string.Empty;
            if (unavailableReasonDisplayName.Contains("TEMPORARILY UNAVAILABLE") || (bedAvailabilityStatus != null && (bedAvailabilityStatus.code == "OOS" || bedAvailabilityStatus.code == "DND" || bedAvailabilityStatus.code == "BED_OOS_VISTA" || bedAvailabilityStatus.code == "BED_OOS_BEDBOARD")))
                classColor = "class=\"colorRed alignCenter\"";
            else if (unavailableReasonDisplayName.Contains("BED ASSIGNED") || unavailableReasonDisplayName.Contains(Constants.BED_HOLD_TEXT))
                classColor = "class=\"colorOrange alignCenter\"";
            else
                classColor = "class=\"colorYellowOrange alignCenter\"";

            if (!string.IsNullOrEmpty(gender))
            {
                if (gender == "Male")
                    classColor = "class=\"colorBlue alignCenter\"";
                else
                    classColor = "class=\"colorPink alignCenter\"";
            }
            return MvcHtmlString.Create(classColor);
        }

        /// <summary>
        /// helper for generating html attributes used for rendering ui elements depending on gender, unavailableTypeCode and unavailableReasonDisplayName
        /// </summary>
        /// <param name="helper">The helper.</param>
        /// <param name="bedAvailabilityStatusCode">The bed availability status code.</param>
        /// <param name="unavailableReasonDisplayName">Display name of the unavailable reason.</param>
        /// <param name="gender">The gender.</param>
        /// <returns></returns>
        public static MvcHtmlString RightClassFor(this HtmlHelper helper, string bedAvailabilityStatusCode, string unavailableReasonDisplayName, string gender)
        {
            CD bedAvailabilityStatus = null;
            if (!string.IsNullOrEmpty(bedAvailabilityStatusCode))
                bedAvailabilityStatus = new CD() { code = bedAvailabilityStatusCode };

            return RightClassFor(helper, bedAvailabilityStatus, unavailableReasonDisplayName, gender);
        }

        /// <summary>
        /// helper for generating html attributes used for rendering ui elements depending on diversion status.
        /// </summary>
        /// <param name="helper">Helper.</param>
        /// <param name="status">Diversion status.</param>
        /// <returns></returns>
        public static MvcHtmlString ForegroundClassFor(this HtmlHelper helper, string status, string durationMessage)
        {
            string classColor = string.Empty;

            if (status == Constants.Yes && durationMessage != Strings.Error)
                classColor = "class=\"foregroundColorRed alignCenter\"";
            else
                classColor = "class=\"alignCenter\"";

            return MvcHtmlString.Create(classColor);
        }

        /// <summary>
        /// Creates the unavailable reason.
        /// </summary>
        /// <param name="helper">The helper.</param>
        /// <param name="wardName">Name of the ward.</param>
        /// <param name="reason">The reason.</param>
        /// <returns></returns>
        public static MvcHtmlString CreateUnavailableReason(this HtmlHelper helper, string wardName, string reason)
        {
            string unavailableReason = string.Empty;
            if (!string.IsNullOrEmpty(reason))
            {
                if (!string.IsNullOrEmpty(wardName))
                    unavailableReason = "<span style=\"font-weight:bold;\">" + wardName + ": </span>" + reason;
                else
                    unavailableReason = reason;

                if (Regex.IsMatch(unavailableReason, Constants.DNRDNIRegex))
                    unavailableReason = unavailableReason + "<br />" + "<span class=\"textDarkRed\" style=\"font-weight:bold;\">" + Strings.WARNINGCheckDNRORDNI + "</span>";
            }

            return MvcHtmlString.Create(unavailableReason);
        }

        /// <summary>
        /// Creates the unavailable reason.
        /// </summary>
        /// <param name="helper">The helper.</param>
        /// <param name="reason">The reason.</param>
        /// <returns></returns>
        public static MvcHtmlString CreateUnavailableReason(this HtmlHelper helper, string reason)
        {
            string unavailableReason = string.Empty;
            if (!string.IsNullOrWhiteSpace(reason))
            {
                if (Regex.IsMatch(reason, Constants.DNRDNIRegex))
                    unavailableReason = reason + "<br />" + "<span class=\"textDarkRed\" style=\"font-weight:bold;\">" + Strings.WARNINGCheckDNRORDNI + "</span>";
                else
                    unavailableReason = "<span>" + reason + "</span>";
            }

            return MvcHtmlString.Create(unavailableReason);
        }

        public static MvcHtmlString MultipleAssignmentsComment(this HtmlHelper helper, bool hasMultipleDivisionsAssigned, bool hasMultipleComments)
        {
            StringBuilder sb = new StringBuilder();
            if (hasMultipleDivisionsAssigned)
            {
                sb.Append("<span class=\"textDarkRed\" style=\"font-weight:bold;\">");
                sb.Append(Constants.BedHasMultipleDivisionsAssignedWarning);
                sb.Append("</span><br />");
            }
            if (hasMultipleComments)
            {
                sb.Append("<span class=\"textDarkRed\" style=\"font-weight:bold;\">");
                sb.Append(Constants.BedHasMultipleCommentsWarning);
                sb.Append("</span><br />");
            }
            return MvcHtmlString.Create(sb.ToString());
        }

        /// <summary>
        /// a html helper for rendering a multiple values (control).
        /// </summary>
        /// <typeparam name="TModel">The type of the model.</typeparam>
        /// <typeparam name="TProperty">The type of the property.</typeparam>
        /// <param name="htmlHelper">The HTML helper.</param>
        /// <param name="expression">The expression.</param>
        /// <param name="url">The URL.</param>
        /// <param name="showButton">if set to <c>true</c> [show button].</param>
        /// <param name="toolTipButton">The tool tip button.</param>
        /// <param name="controlId">The control id.</param>
        /// <param name="htmlAttributes">The HTML attributes.</param>
        /// <returns></returns>
        public static MvcHtmlString MultipleValues<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper,
            Expression<Func<TModel, TProperty>> expression, bool showButton, string toolTipButton, HtmlAttributes htmlAttributes)
        {
            if (htmlAttributes != null && !htmlAttributes.IsVisible)
                return MvcHtmlString.Create(null);

            StringBuilder multipleValueHtml = new StringBuilder();

            var newAttributes = htmlAttributes.BuildAttributesFroMultipleValuesControl();

            htmlHelper.ChangeXssValue(expression);

            string inputText = InputExtensions.TextBoxFor<TModel, TProperty>(htmlHelper, expression, newAttributes).ToHtmlString();
            multipleValueHtml.Append(inputText);
            if (showButton)
            {
                string ctrlId = inputText.Substring(inputText.IndexOf("id=") + 4);
                ctrlId = ctrlId.Substring(0, ctrlId.IndexOf("\""));
                multipleValueHtml.Append("&nbsp;");
                multipleValueHtml.Append("<span>");
                multipleValueHtml.Append("<input type=\"button\" id =\"btnViewStandardList_" + ctrlId + "\" name=\"btnViewStandardList\" value=\"\" title=\"" + toolTipButton + "\" class=\"button_add\" onclick=\"StandardCommentsButtonClick('" + ctrlId + "')\"  />");
                multipleValueHtml.Append("</span>");
            }
            return MvcHtmlString.Create(multipleValueHtml.ToString());
        }

        public static void ChangeXssValue<TModel, TProperty>(this HtmlHelper<TModel> htmlHelper, Expression<Func<TModel, TProperty>> expression)
        {
            ModelMetadata metadata = ModelMetadata.FromLambdaExpression(expression, htmlHelper.ViewData);
            if (metadata.AdditionalValues.ContainsKey("AddXssKey") && metadata.Model != null)
            {
                PropertyInfo propertyInfo = htmlHelper.ViewData.Model.GetType().GetProperty(metadata.PropertyName);
                propertyInfo.SetValue(htmlHelper.ViewData.Model, xssEncoder.Decode(metadata.Model.ToString()), null);
            }
        }
    }

    public static class RazorExtensions
    {
        /// <summary>
        /// Creates a generic pager for any data source
        /// </summary>
        /// <param name="urlFormat">The link format, like /controller/method/{0}</param>
        /// <param name="totalPages">The count of pages</param>
        /// <param name="currentPage">The current page number (note that this isn't an index)</param>
        /// <returns>System.String</returns>
        public static MvcHtmlString Pager(this HtmlHelper helper, int itemsPerPage, int currentPage, int totalCount)
        {
            StringBuilder sb = new StringBuilder();
            if (totalCount > 0 && totalCount > itemsPerPage)
            {
                int totalPages = totalCount / itemsPerPage;
                if (totalCount % itemsPerPage > 0)
                    totalPages += 1;
                if (currentPage > totalPages)
                    currentPage = totalPages;
                sb.Append(@"<div class=""alignCenter"" style=""padding-top:20px;"">|&nbsp;");
                for (int k = 1; k <= totalPages; k++)
                {
                    if (k == currentPage)
                        sb.Append(@"<label class=""textRed"">");
                    else
                    {
                        sb.Append(@"<a href=""javascript:changePage('");
                        sb.Append(k);
                        sb.Append(@"');"">");
                    }
                    sb.Append(@"<b>");
                    sb.Append(k.ToString());
                    sb.Append(@"</b>");
                    if (k == currentPage)
                        sb.Append(@"</label>&nbsp;|&nbsp;");
                    else
                        sb.Append(@"</a>&nbsp;|&nbsp;");
                }
                sb.Append(@"</div>");
            }
            return MvcHtmlString.Create(sb.ToString());
        }

        public static MvcHtmlString TimeSpanFormat(this HtmlHelper helper, TimeSpan time)
        {
            StringBuilder resultBuilder = new StringBuilder();
            resultBuilder.Append(((int)time.TotalHours).ToString());
            resultBuilder.Append(":");
            resultBuilder.Append((((int)time.TotalMinutes) - ((int)time.TotalHours) * 60).ToString());

            return MvcHtmlString.Create(resultBuilder.ToString());
        }
    }
}
